/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.core.Computer;
import jace.core.RAM;
import jace.hardware.massStorage.DirectoryNode;
import jace.hardware.massStorage.DiskNode;
import jace.hardware.massStorage.FreespaceBitmap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ProdosVirtualDisk {
    public static int BLOCK_SIZE = 512;
    public static int MAX_BLOCK = 65535;
    public static int VOLUME_START = 2;
    public static int FREESPACE_BITMAP_START = 6;
    byte[] ioBuffer;
    File physicalRoot;
    Map<Integer, DiskNode> physicalMap = new HashMap<Integer, DiskNode>();
    DirectoryNode rootDirectory;
    FreespaceBitmap freespaceBitmap;

    public ProdosVirtualDisk(File rootPath) throws IOException {
        this.physicalRoot = rootPath;
        if (!this.physicalRoot.exists() || !this.physicalRoot.isDirectory()) {
            throw new IOException("Root path must be a directory that exists!");
        }
        this.rootDirectory = new DirectoryNode(this, this.physicalRoot, VOLUME_START);
        this.rootDirectory.setName("VIRTUAL");
        this.allocateEntry(this.rootDirectory);
        this.freespaceBitmap = new FreespaceBitmap(this, FREESPACE_BITMAP_START);
        this.allocateEntry(this.freespaceBitmap);
        this.ioBuffer = new byte[BLOCK_SIZE];
    }

    public void mliRead(int block, int bufferAddress) throws IOException {
        DiskNode node = this.physicalMap.get(block);
        RAM memory = Computer.getComputer().getMemory();
        Arrays.fill(this.ioBuffer, (byte)0);
        if (node == null) {
            System.out.println("Reading unknown block?!");
            for (int i = 0; i < BLOCK_SIZE; ++i) {
                memory.write(bufferAddress + i, (byte)0, false);
            }
        } else {
            node.readBlock(this.ioBuffer);
            for (int i = 0; i < BLOCK_SIZE; ++i) {
                memory.write(bufferAddress + i, this.ioBuffer[i], false);
            }
        }
    }

    public void mliWrite(int block, int bufferAddress) throws IOException {
        System.out.println("Write block " + block + " to " + Integer.toHexString(bufferAddress));
        throw new IOException("Write not implemented yet!");
    }

    public File locateFile(File rootPath, String string) {
        File mostLikelyMatch = null;
        for (File f : rootPath.listFiles()) {
            if (f.getName().equalsIgnoreCase(string)) {
                return f;
            }
            if (!string.toUpperCase().startsWith(f.getName().toUpperCase()) || mostLikelyMatch != null && f.getName().length() <= mostLikelyMatch.getName().length()) continue;
            mostLikelyMatch = f;
        }
        return mostLikelyMatch;
    }

    public int getNextFreeBlock() throws IOException {
        for (int i = 2; i < MAX_BLOCK; ++i) {
            if (this.physicalMap.containsKey(i)) continue;
            return i;
        }
        throw new IOException("Virtual Disk Full!");
    }

    public void allocateEntry(DiskNode node) {
        this.physicalMap.put(node.baseBlock, node);
        for (DiskNode sub : node.additionalNodes) {
            this.physicalMap.put(sub.getBaseBlock(), sub);
        }
    }

    public void deallocateEntry(DiskNode node) {
        if (this.physicalMap.get(node.baseBlock) != null && this.physicalMap.get(node.baseBlock).equals(node)) {
            this.physicalMap.remove(node.baseBlock);
        }
        for (DiskNode sub : node.additionalNodes) {
            if (this.physicalMap.get(sub.getBaseBlock()) == null || !this.physicalMap.get(sub.baseBlock).equals(sub)) continue;
            this.physicalMap.remove(sub.getBaseBlock());
        }
    }

    public boolean isAllocated(int i) {
        return this.physicalMap.containsKey(i);
    }
}

